 ; Ŀ
 ;   Leda - draws a leader until it hears a <Return>, then runs Dtext.     
 ;   L3da - similar, but for 3mm text.                                     
 ;   Copyright 1994, 1999, 2001, 2005, 2010 by Rocket Software Ltd.        
 ;   A handy program to have when meeting Martians.  Or swans.             
 ; 

 ; Ŀ
 ;   Grok - grdraw over a set of grlines.                                  
 ;   Takes one argument, a list of points.  Returns the empties.           
 ; 
 (DEFUN GROK (palist / sub1 sub2)
  (while (setq sub1 (car palist))
         (setq palist (cdr palist))
         (if (and sub1 sub2) (grdraw sub1 sub2 -1))
         (setq sub2 sub1))
 (princ))
 ; Ŀ
 ;   Grok end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Leda.                                                      
 ;   Arguments: Txtsz, the height of text to make.                         
 ;              Laya, the layer to put it on.                              
 ; 
 (DEFUN LEDA (txtsz laya / orth osm disc *error* aa bb palist cc ang)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setvar "orthomode" 0)
  (setq orth (getvar "orthomode"))
  (setq osm (getvar "osmode"))
  (setvar "osmode" 0)
 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
  (setq disc (misps))
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
 (defun *error* (shk)
  (if palist (grok palist))
  (if shk (write-line shk))
  (setvar "orthomode" orth)
  (setvar "osmode" osm)
  (command "undo" "end")
 (princ))
 ; Ŀ
 ;   If the text layer exists make it current, otherwise make it.          
 ; 
  (malaya laya)
  (setq aa (getpoint "Start point:\n"))
  (setq bb (getpoint aa "Next point:\n"))
 ; Ŀ
 ;   Start the leader command.                                             
 ; 
  (command "leader" aa bb)
  (grdraw aa bb -1)
  (setq palist (list aa bb))
  (while (setq cc (getpoint bb "Next point:\n"))
         (if (= (distance bb cc) 0) (write-line "Try moving the cursor\n")
             (progn
                   (command cc)
                   (grdraw cc bb -1)
                   (setq palist (append palist (list cc)))
                   (setq ang (angle bb cc))
                   (if cc (setq bb cc)))))
 ; Ŀ
 ;   Make sure we have a final point, get the angle between the last two.  
 ; 
  (if (null cc)
      (progn
           (setq cc bb)
           (setq ang (angle aa bb))))
 ; Ŀ
 ;   Place the text.                                                       
 ; 
  (if (or (> ang (* 1.5 pi)) (< ang (/ pi 2)))
      (progn
          (if (/= ang 0) (command (setq cc (polar cc 0 (* disc 3)))))
          (command "" "" "None")
          (grok palist)
          (setq palist ())
          (setq aa (polar cc 0 (* disc 2)))
          (command "dtext" "ml" aa (* txtsz disc) "0"))
      (progn
          (if (/= ang pi) (command (setq cc (polar cc pi (* disc 3)))))
          (command "" "" "None")
          (grok palist)
          (setq palist ())
          (setq aa (polar cc pi (* disc 2)))
          (command "dtext" "mr" aa (* txtsz disc) "0")))
 ; Ŀ
 ;   Restore sysvars, end.                                                 
 ; 
  (*error* ())
 (princ))
 ; Ŀ
 ;   Subroutine Leda end.                                                  
 ; 

 ; Ŀ
 ;   L3da.                                                                 
 ; 
 (DEFUN C:L3DA ()
  (leda 3 "text3")
 (princ))

 ; Ŀ
 ;   Leda.                                                                 
 ; 
 (DEFUN C:LEDA ()
  (leda 2.5 "text2")
 (princ))
